# -*- coding: utf-8 -*-
"""NG911 GIS Toolkit (Pro) -- NG911_GIS_Toolkit_Pro.pyt

Notes
----------
:synopsis: Script for ArcGIS Pro to utilize `NG911 GIS Toolkit (Pro)`
:authors: Riley Baird (OK), Emma Baker (OK)
:created: July 23, 2024
:modified: December 16, 2024
"""

import sys

# tool package un-imports
start_package_name = "ng911ok"
del_list = [modname for modname, mod in sys.modules.items() if start_package_name in (getattr(mod, "__package__", None) or "")]
for modname in del_list:
    del sys.modules[modname]

## tool package imports
# comparison
from ng911ok.tools.comparison import FeatureClassCompareTool, GeodatabaseCompareTool
# enhancement
from ng911ok.tools.enhancement import AddNG911Topology, CalculateConvertFix#, GenerateFishboneAnalysis
# msag
from ng911ok.tools.msag.msagng911comparison import MSAGNG911Comparison
# prep
from ng911ok.tools.prep.assignnguid import AssignNGUID
from ng911ok.tools.prep.creategdb import CreateGDBTool
from ng911ok.tools.prep.fieldmap import FieldMapTool
from ng911ok.tools.prep.createblankfc import CreateBlankFCTool
from ng911ok.tools.prep.splitesn import SplitESN
# submission
from ng911ok.tools.submission import CheckAllAndZipTool, ExportShapefilesTool, ExportToZipTool
# validation
from ng911ok.tools.validation.validate import ValidateGeodatabase


class Toolbox(object):
    def __init__(self):
        """Define the toolbox (the name of the toolbox is the name of the
        .pyt file)."""
        self.label = "NG911 GIS Toolkit (Pro)"
        self.alias = "ng911ok"

        # List of tool classes associated with this toolbox
        self.tools = [
            # prep: 1 - Prep
            AssignNGUID,
            CreateGDBTool,
            FieldMapTool,
            CreateBlankFCTool,
            SplitESN,
            # validation: 2 - Validation
            ValidateGeodatabase,
            # enhancement: 3 - Enhancement
            AddNG911Topology,
            CalculateConvertFix,
            # GenerateFishboneAnalysis,
            # msag: 4 - MSAG
            MSAGNG911Comparison,
            # comparison: 5 - Comparison
            FeatureClassCompareTool,
            GeodatabaseCompareTool,
            # submission: 6 - Submission
            CheckAllAndZipTool,
            ExportShapefilesTool,
            ExportToZipTool
        ]
